<?php 
    /**
    *
    * copyright (c) 2013-2023 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/index.php?alias=linee-guida-per-luso-del-logo-geecom
    */

    $arrayStatiRicercabili = ["Pubblicati"=>"si","Non pubblicati"=>"no"];

    $impostazioniLingue     = $geecomDb->leggiSingolaRiga("geecB_impostazioniLingue",1);
    $campiAggiuntiviRicerca = array("tipoRicerca"=>"prodotti");
    if(isset($_GET["cerca"]) && $_GET["tipoRicerca"]=="prodotti") {
        $cercaProdotti    = $_GET["cerca"];
        $parametriRicerca = ["nome"=>filter_input(INPUT_GET, "cerca",FILTER_SANITIZE_ADD_SLASHES),"ean"=>filter_input(INPUT_GET, "cerca",FILTER_SANITIZE_ADD_SLASHES)];
    }
    else {
        $cercaProdotti = "";
        $parametriRicerca = ["tipoProdotto"=>["fisico","digitale","abbonamento"]];
    }
    
    $parametri = array("tabella"=>"geecEc_prodotti", "elementiPerPagina"=>$elementiPerPagina,"parametriRicerca"=>$parametriRicerca,"ajax"=>false);
    
    $ricerca = new Ricerca($geecomDb, $parametri, $impostazioniRicerca,"index.php");
    
    if(isset($_GET["lingua"])) {
        $ricerca->setCondizionePrincipale("(lingua = '$linguaSelezionata' AND pubblicato LIKE '%$statoSelezionato%') AND ");
    }
    else {
        $ricerca->setCondizionePrincipale("lingua = '".$impostazioniLingue["linguaPrincipale"]."' AND ");
    }
?>
    <h4 class="mb-4 title">Prodotti</h4>
    <a href="creaProdotto.php" class="btn btn-sm btn-primary" >
	Crea prodotto<i class="fas fa-plus ml-2"></i>
    </a>
    <hr> 

    <div class="d-flex justify-content-between mb-3">
        <?php
            $ricerca->stampaSelectNumeroElementi($cercaProdotti,$campiAggiuntiviRicerca);
        ?>

    </div>
    <div class="table-responsive table-sm">
        <?php
            if(isset($_GET["pag"])) {
                $ris = $ricerca->eseguiRicerca($_GET["pag"],"OR");
            }
            else {
                $ris = $ricerca->eseguiRicerca(1,"OR");
            }

            $colonne = array("ID","Lingua","EAN","Nome","Categoria","Prezzo €","Quantità","Stato","");
            $tabella = new Tabella("tabella", "table table-striped table-hover",$colonne);
            $tabella->setTipo("normale");
            while($prodotto = $ris->fetch_assoc()) {
                $nomeEscape    = filter_var($prodotto["nome"],FILTER_SANITIZE_ADD_SLASHES);
                if($prodotto["categoria"]>0) {
                    $datiCategoria = $geecomDb->leggiSingolaRiga("geec_categorie",$prodotto["categoria"]);
                    $nomeCategoria = (!$datiCategoria) ? "" : $datiCategoria["nome"];
                }
                else {
                    $nomeCategoria = "";
                }
                
                if($prodotto["pubblicato"]=="si") {
                    $stringaStato = "<i class=\"fas fa-circle text-success\" data-toggle=\"tooltip\" data-placement=\"bottom\" data-original-title=\"pubblicato\"></i>";
                    $azioni = array("modifica"=>"creaProdotto.php?id={$prodotto["id"]}","elimina"=>"apriPopupEliminaProdotto({$prodotto["id"]},'$nomeEscape')");
                }
                else {
                    $stringaStato = "<i class=\"fas fa-circle text-black-50\" data-toggle=\"tooltip\" data-placement=\"bottom\" data-original-title=\"bozza\"></i>";
                    $azioni = array("modifica"=>"creaProdotto.php?id={$prodotto["id"]}","elimina"=>"apriPopupEliminaProdotto({$prodotto["id"]},'$nomeEscape')");
                }
                $tabella->aggiungiNuovaRiga(array($prodotto["id"],"<img class=\"bandiera\" src=\"../../../".percorsoImmagineBandiera($prodotto["lingua"])."\">",$prodotto["ean"],"<a href=\"creaProdotto.php?id={$prodotto["id"]}\"><b>".$prodotto["nome"]."</b></a>",$nomeCategoria,$prodotto["prezzo"],$prodotto["disponibilita"],$stringaStato),$azioni);
            }
            $tabella->stampa("rigaProdotto",0);
            
            if($cercaProdotti=="") {
                $ricerca->stampaPaginazione(true,"index.php",20,"pagination-sm");
            }
            else {
                $ricerca->stampaPaginazione(true,"index.php?tipoRicerca=prodotti&cerca=$cercaProdotti&lingua=$linguaSelezionata",20,"pagination-sm");
            }
        ?>
    </div>
